<?php
/**
 * @package     e4j.VikUpdater
 * @subpackage  Library.Software
 * @copyright   Copyright (C) 2023 e4j - Extensionsforjoomla.com. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace E4J\VikUpdater\Software;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Factory class to create software instances.
 * 
 * @since 1.4
 */
abstract class Factory
{
    /**
     * Creates a new software instance according to the provided arguments.
     * 
     * @param   array|object  $args
     * 
     * @return  E4J\VikUpdater\Software\Version
     */
    public static function create($args)
    {
        $args = new \JRegistry($args);

        switch ($args->get('alias'))
        {
            case 'com_vikappointments': $class = 'VikAppointments'; break;
            case 'com_vikbooking':      $class = 'VikBooking';      break;
            case 'com_vikevents':       $class = 'VikEvents';       break;
            case 'com_vikrentcar':      $class = 'VikRentCar';      break;
            case 'com_vikrentitems':    $class = 'VikRentItems';    break;
            case 'com_vikrestaurants':  $class = 'VikRestaurants';  break;
            default: $class = 'NullPlugin';
        }

        $class = '\\E4J\\VikUpdater\\Software\\Plugins\\' . $class;

        return new $class($args->toArray());
    }
}
