<?php  
/**------------------------------------------------------------------------
 * mod_vikcounter
 * ------------------------------------------------------------------------
 * author    Valentina Arras - Extensionsforjoomla.com
 * copyright Copyright (C) 2021 extensionsforjoomla.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.extensionsforjoomla.com
 * Technical Support:  templates@extensionsforjoomla.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted Area'); 

$document = JFactory::getDocument();
JHtml::_('stylesheet', JURI::root().'modules/mod_vikcounter/mod_vikcounter.css');
$fontawesome_library = $params->get('fontawesome_library');

if($fontawesome_library) {
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikcounter/css/all.min.css');
}

$get_pgsize = $params->get('pg_size');
$slidejstr = $params->get('viksliderimages', '[]');
$slides = json_decode($slidejstr);

if (count($slides)) {
	foreach ($slides as $sk => $slide) {
		if ((int)$slide->published < 1) {
			continue;
		}
		$imgabpath = JPATH_SITE . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $slide->image);

		/**
		 * Images path may contain information about their size, like:
		 * images/background-04.jpg#joomlaImage://local-images/background-04.jpg?width=1920&height=1080
		 * So we get rid of anything after the hash.
		 * 
		 * @joomla4
		 */
		$img_hash = strpos($imgabpath, '#');
		if ($img_hash !== false) {
			$imgabpath = substr_replace($imgabpath, '', $img_hash);
		}

		$slider_entry = '<div class="vikcounter-item col-xs-6 col-sm-'.$get_pgsize.'">';
			$slider_entry .= '<div class="vikcounter-item-inner">';
				if (is_file($imgabpath)) {
					$slider_entry .= '<img class="vikcounter-img" src="'.JURI::root().$slide->image.'" alt="'.$slide->title.'"/>';
				}
				if ( !empty($slide->icon) )	{
					$slider_entry .= '<span class="vikcounter-icon">'.$slide->icon.'</span>';
				}
				$slider_entry .= '<span class="vikcounter-count" id="vikcounter-count-'.$module->id.'-'.$sk.'">'.$slide->valuecount.'</span>';
				if (!empty($slide->title)) {
					$slider_entry .= '<h3 class="vikcounter-title">'.$slide->title.'</h3>';
				}
				if (!empty($slide->caption)) {
					$slider_entry .= '<div class="vikcounter-caption">'.$slide->caption.'</div>';
				}
			$slider_entry .= "</div>";
		$slider_entry .= "</div>";
		$arrslide[] = $slider_entry;
	}
}

?>
<a id="vikcounter-start"></a>
<div class="vikcounter container-fluid">
	<div class="vikcounter-inner row">
		<?php 
			if (is_array($arrslide)) {
			foreach($arrslide as $vsl) {
			echo $vsl;
			}
		}
		?>
	</div>
</div>

<script>
jQuery.noConflict();
Function.prototype.debounce = function(threshold) {
	var callback = this;
	var timeout;
	return function() {
		var context = this,
			params = arguments;
		window.clearTimeout(timeout);
		timeout = window.setTimeout(function() {
			callback.apply(context, params);
		}, threshold);
	};
};
jQuery.fn.isOnScreen = function(x, y) {
	if (x == null || typeof x == 'undefined') x = 1;
	if (y == null || typeof y == 'undefined') y = 1;
	var win = jQuery(window);
	var viewport = {
		top: win.scrollTop(),
		left: win.scrollLeft()
	};
	viewport.right = viewport.left + win.width();
	viewport.bottom = viewport.top + win.height();
	var height = this.outerHeight();
	var width = this.outerWidth();
	if (!width || !height) {
		return false;
	}
	var bounds = this.offset();
	bounds.right = bounds.left + width;
	bounds.bottom = bounds.top + height;
	var visible = (!(viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom));
	if (!visible) {
		return false;
	}
	var deltas = {
		top: Math.min(1, (bounds.bottom - viewport.top) / height),
		bottom: Math.min(1, (viewport.bottom - bounds.top) / height),
		left: Math.min(1, (bounds.right - viewport.left) / width),
		right: Math.min(1, (viewport.right - bounds.left) / width)
	};

	return (deltas.left * deltas.right) >= x && (deltas.top * deltas.bottom) >= y;
};
		
//cambia il selettore con ID o classe da leggere, meglio ID cosi hanno sempre la posizione precisa e singola
var vikcounter_start = false;
var vikcounter_block_cont = jQuery('.vikcounter-inner');
var vikcounter_check = function() {
	var vikcounter_cont_visible = vikcounter_block_cont.isOnScreen(0.1, 0.5);
	if (vikcounter_cont_visible === true && !vikcounter_start) {
		vikcounter_start = true;
		jQuery('.vikcounter-count').each(function () {
		jQuery(this).prop('Counter',0).animate({
				Counter: jQuery(this).text()
		}, {
				duration: 4000,
				easing: 'swing',
				step: function (now) {
						jQuery(this).text(Math.ceil(now));
				}
		});
	});
	}
}
jQuery(document).ready(function() {
	var debounced = vikcounter_check.debounce(50);
	jQuery(window).on('scroll', debounced);
});
</script>
	