<?php
/**------------------------------------------------------------------------
 * mod_vikicons - VikIcons
 * ------------------------------------------------------------------------
 * author    Alessio Gaggii - e4j - Extensionsforjoomla.com
 * copyright Copyright (C) 2021 e4j - Extensionsforjoomla.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  tech@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die ('Restricted access');

jimport('joomla.form.formfield');

class JFormFieldVikIconsmanager extends JFormField
{
	protected $icons = null;
	
	protected $type = 'VikIconsmanager';

	protected function getInput()
	{
		$top_form = '<div id="vikicons-slides-container">'.
					'	<div id="vikicons-slides-add-wrapper">'.
					'		<a href="#add"><span class="icon-plus-circle"></span>'.JText::_('VIKICADDSLIDE').'</a>'.
					'	</div>'.
					'	<div id="vikicons-slides-add-form">'.$this->loadFormData('add').'</div>'.
					'</div>';
		
		$edit_form = $this->loadFormData('edit');
		
		$data_form = '<div id="invisible" style="display: none;">'.
					'	<div class="vikicons-slider-entry">'.
					'		<div class="vikicons-slider-entry-inner">'.
					'			<div class="vikicons-slider-divtitle"><span class="vikicons-slider-title" title="'.JText::_('VIKTITLEDESC').'"></span></div>'.
					'			<div class="vikicons-slider-edit">'.
					'			<div class="vikicons-slider-remove"><a href="#remove" class="vikicons-slider-removebtn" title="'.JText::_('VIKICREMOVESLIDE').'"><span class="icon-unpublish"></span>'.JText::_('VIKICREMOVESLIDE').'</a></div>'.
					'			<div class="vikicons-slider-editbtn"><a href="#edit" class="vikicons-slider-editbtn" title="'.JText::_('VIKICEDITSLIDE').'"><span class="icon-pencil-2"></span><span>'.JText::_('VIKICEDITSLIDE').'</span></a></div>'.
					'			<div class="vikicons-slider-status"><div class="vikicons_publishediv"><span class="icon-radio-checked"></span><span class="vikicons_published">'.JText::_('VIKICPUBLISHEDSLIDE').'</span></div><div class="vikicons_unpublisheddiv"><span class="icon-radio-unchecked"></span><span class="vikicons_unpublished">'.JText::_('VIKICUNPUBLISHEDSLIDE').'</span></div></div>'.
					'		</div></div>'.
					'		<div class="vikicons-slider-editcontainer">'.
					'			<div class="vikicons-slider-editor">'.$edit_form.'</div>'.
					'		</div>'.
					'	</div>'.
					'</div>';
		
		$slides_list = '<div id="vikicons-allslides"></div>';

		$val_container = '<textarea name="'.$this->name.'" id="'.$this->id.'" style="display: none;">'.$this->value.'</textarea>';
		
		return $data_form . $top_form . $slides_list . $val_container;
	}
	
	private function loadFormData($type = 'add') {
		$is_j4 = false;
		$version = new JVersion();
		if (version_compare($version->getShortVersion(), '4.0') >= 0) {
			$is_j4 = true;
		}
		$form_data = '';
		$media_mng_link_add  = 'index.php?option=com_media&view=images&tmpl=component&asset=com_modules&author=&fieldid=jform_params_img&folder=';
		$media_mng_link_edit = 'index.php?option=com_media&view=images&tmpl=component&asset=&author=&fieldid=jform_params_edit_img&folder=';

		$doc = JFactory::getDocument();
		$doc->addStylesheet(JUri::root() . 'modules/mod_vikicons/src/all.css');

		if ($type == 'add') {
			// Joomla JS function for Media Manager
			$jscript = '	function jInsertFieldValue(value,id) {'."\n";
			$jscript .= '		var old_id = document.getElementById(id).value;'."\n";
			$jscript .= '		if (old_id != id) {'."\n";
			$jscript .= '			document.getElementById(id).value = value;'."\n";
			$jscript .= '		}'."\n";
			$jscript .= '	}'."\n";
			$doc->addScriptDeclaration($jscript);
			//
		}

		// Slide Icon
		$form_data .= '<div class="vikicons-slideparam-block vikicons-slideparam-blockparm">';
		$form_data .= '<h3>'.JText::_('VIKICIMGBGSLIDE').'</h3>';
		$form_data .= '<div class="control-label"><label>'.JText::_('VIKICTYPE').'</label></div>';

		// Select Font Awesome Icon type
		$form_data .= '<select name="jform[params][icontype]" id="jform_params_icontype_'.$type.'" value="" class="custom-select vikiconsparam_'.$type.'_icontype" />';
		$form_data .= '<option value="fa" selected="selected">Default</option>';
		$form_data .= '<option value="far">Regular</option>';
		$form_data .= '<option value="fas">Solid</option>';
		$form_data .= '<option value="fab">Brand</option>';
		$form_data .= '<option value="fal">Light (PRO)</option>';
		$form_data .= '</select>';

		$form_data .= '<br /><br />';
		$form_data .= '<div class="control-label"><label>'.JText::_('VIKICCHOOSE').'</label></div>';

		// Select Icon 
		$form_data .= '<div class="vikiconsparam_'.$type.'_iconsel"><select name="jform[params][icon]" id="jform_params_icon_'.$type.'" value="" class="custom-select vikiconsparam_'.$type.'_icon" />';
		$form_data .= '<option value="">- select an icon -</option>';
		
		foreach ($this->getAvailableIcons() as $class => $name)
		{
			$form_data .= "<option value=\"$class\">$name</option>";
		}

		$form_data .= '</select>';
		$form_data .= '<span class="icon-preview" style="margin-left: 10px;"><i class="" style="font-size: 16px;vertical-align: middle;"></i></span></div>';
		$form_data .= '<div class="usage-desc">';
			$form_data .= '<h4>Can\'t you see your icon?</h4><p>It means that the icon selected doesn\'t belong to the Icon Type selected. An example, the Facebook icon belong to the <em>Brand</em> icon type. Change the Icon Type parameter until you see the icon preview correctly.</p>';
		$form_data .= '</div>';
		$form_data .= '</div>';

		// Select Image Icon
		if($type == 'add') {
			$form_data .= '<div class="vikicons-slideparam-block vikicons-slideparam-image">';
			$form_data .= '	<div class="control-label"><label>'.JText::_('VIKCSIMGBGSLIDE').'</label></div>';

			if ($is_j4) {
				$form_data .= $this->getMediaField('jform[params][img]', null, ['id' => 'jform_params_img', 'class'=> 'vikiconsparam_'.$type.'_image']);
			}  else {
				$form_data .= '<div class="input-group">';
				$form_data .= '	<input type="text" name="jform[params][img]" id="jform_params_img" value="" class="form-control vikiconsparam_'.$type.'_image" />';
				$form_data .= '	<a class="btn modal modal-media" title="'.JText::_('JSELECT').'" href="' . $media_mng_link_add . '" rel="{handler: \'iframe\', size: {x: 800, y: 500}}">'.JText::_('JSELECT').'</a>';
				$form_data .= '	<a title="'.JText::_('JCLEAR').'" class="btn btn-outline-secondary" href="#" onclick="javascript:document.getElementById(\'jform_params_img\').value=\'\';return false;">'.JText::_('JCLEAR').'</a></p>';
				$form_data .= '</div>';
			}
			$form_data .= '</div>';
		} else {
			if ($is_j4) {
				$form_data .= '<div class="vikicons-slideparam-block" style="display: block !important;">';
				$form_data .= '	<div class="control-label"><label>'.JText::_('VIKCSIMGBGSLIDE').'</label></div>';
				$form_data .= $this->getMediaField('jform_params_edit_img', null, ['id' => 'jform_params_edit_img', 'class'=> 'vikiconsparam_'.$type.'_image']);
				$form_data .= '</div>';
			} else {
				$form_data .= '<div class="vikicons-slideparam-block vikicons-slideparam-image">';
				$form_data .= '	<div class="control-label"><label>'.JText::_('VIKCSIMGBGSLIDE').'</label></div>';
				$form_data .= '	<input type="text" name="jform_params_edit_img" id="jform_params_edit_img" value="" class="form-control vikiconsparam_'.$type.'_image" />';
				$form_data .= '	<a class="btn modal modal-media" title="'.JText::_('JSELECT').'" href="' . $media_mng_link_edit . '" target="_blank" rel="{handler: \'iframe\', size: {x: 800, y: 500}}">'.JText::_('JSELECT').'</a>';
				$form_data .= '	<a title="'.JText::_('JCLEAR').'" href="#" onclick="javascript:document.getElementById(\'jform_params_edit_img\').value=\'\';return false;" class="btn btn-outline-secondary modal-media-clear">'.JText::_('JCLEAR').'</a>';
				$form_data .= '</div>';
			}
		}
		
		// -start- Box Details
		$form_data .='<div class="vikicons-slideparam-blockparm">';
		//Icon Details header 
		$form_data .= '<div class="vikicons-slideparam-block"><div class="vikicons-slideparam-header"><h3>'.JText::_('VIKICSLIDEDETAILS').'</h3></div></div>';
		//Icon Title
		$form_data .= '<div class="vikicons-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKTITLEDESC').'">'.JText::_('VIKTITLE').'</label></div><input type="text" class="form-control vikiconsparam_'.$type.'_title" /></div>';
		//Icon Description
		$form_data .= '<div class="vikicons-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKICSLIDECAPTIONESC').'">'.JText::_('VIKICSLIDECAPTION').'</label></div><textarea class="form-control vikiconsparam_'.$type.'_caption" rows="10" cols="5"></textarea></div>';
		//Icon Link Link
		$form_data .= '<div class="vikicons-slideparam-block"><div class="control-label"><label title="'.JText::_('READMOREDESC').'">'.JText::_('READMORE').'</label></div><input type="text" class="form-control vikiconsparam_'.$type.'_linkicon" /></div>';
		//Destination Link
		$form_data .= '<div class="vikicons-slideparam-block"><div class="control-label"><label title="'.JText::_('READMOREDEST').'">'.JText::_('DESTINATIONLINK').'</label></div>';
			$form_data .= '<select name="jform[params][linkdest]" id="jform_params_linkdest_'.$type.'" value="" class="custom-select vikiconsparam_'.$type.'_linkdest">';
			$form_data .= '<option value="1" selected="selected">New Tab</option>';
			$form_data .= '<option value="0">Same Page</option>';
			$form_data .= '</select>';
		$form_data .= '</div>';
		// -end- Box Details
		$form_data .='</div>';
		//Icon Published
		$form_data .='<div class="vikicons-slideparam-editbox">';
		$form_data .= '<div class="vikicons-slideparam-block vikicons-slideparam-status"><div class="control-label"><label>'.JText::_('VIKICSLIDESTATUS').'</label></div><select class="custom-select vikiconsparam_'.$type.'_published"><option value="1">'.JText::_('VIKICPUBLISHEDSLIDE').'</option><option value="0">'.JText::_('VIKICUNPUBLISHEDSLIDE').'</option></select></div>';
		//Add/Cancel buttons
		$form_data .= '<div class="vikicons-slideparam-block vikicons-slideparam-block-'.$type.'"><a href="#save" class="btn btn-success">'.JText::_('VIKICBTNADDSLIDE').'</a><a href="#cancel" class="btn btn-outline-danger">'.JText::_('VIKICBTNCANCSLIDE').'</a></div>';
		$form_data .='</div>';

		$jscript = "jQuery(document).ready(function() {
			jQuery('select[name=\"jform[params][icon]\"]').on('change', function(){
				jQuery(this).parent().find('span.icon-preview i').attr('class', jQuery('select[name=\"jform[params][icontype]\"]').val()+' fa-'+jQuery(this).val());
			});
			jQuery('select[name=\"jform[params][icontype]\"]').on('change', function(){
				jQuery('select[name=\"jform[params][icon]\"]').trigger('change');
			});
		});";

		$doc->addScriptDeclaration($jscript);
		
		return '<div class="vikicons-newslide-cont"><div class="vikicons-newslide-cont-'.$type.'">'.$form_data.'</div></div>';
	}

	protected function getAvailableIcons()
	{
		if ($this->icons === null)
		{
			$font_awesome_file = implode(DIRECTORY_SEPARATOR, array(JPATH_SITE, 'modules', 'mod_vikicons', 'src', 'all.css'));

			$handle = fopen($font_awesome_file, 'r');

			if (!$handle)
			{
				throw new Exception('Impossible to read the Font Awesome contents.', 403);
			}

			$buffer = "";

			while (!feof($handle))
			{
				$buffer .= fread($handle, 1024);
			}

			fclose($handle);

			preg_match_all("/fa-([a-zA-Z\-_]+):before/", $buffer, $matches);

			$this->icons = array();

			foreach ($matches[1] as $icon)
			{
				$key = $icon;

				$icon = preg_replace("/-o$/", " (outline)", $icon);
				$icon = preg_replace("/-/", " ", $icon);
				$icon = ucwords($icon);

				$this->icons[$key] = $icon;
			}

			asort($this->icons);
		}

		return $this->icons;
	}

	/**
	 * Method used to obtain a Joomla media form field.
	 * Compatible with J4.
	 *
	 * @return 	string 	The media in HTML.
	 *
	 * @since 	September 2021
	 */
	private function getMediaField($name, $value = null, array $data = array())
	{
		// init media field
		$field = new JFormFieldMedia(null, $value);
		// setup an empty form as placeholder
		$field->setForm(new JForm('vikicons.media'));

		// force field attributes
		$data['name']  = $name;
		$data['value'] = $value;

		/**
		 * J4.x requires us to use the magic method to set the properties id and types
		 * or the media manager won't work in case of multiple instances on the same page,
		 * nor would it display any image unless the proper types is passed.
		 */

		static $index = 1;
		// use an incremental value for the id
		$field->id = preg_replace("/[^A-Za-z0-9\-_]+/", '', $name) . $index++;
		// accept all images
		$field->types = 'images';

		if (empty($data['previewWidth']))
		{
			// there is no preview width, set a defualt value
			// to make the image visible within the popover
			$data['previewWidth'] = 480;
		}

		// render the field	
		return $field->render('joomla.form.field.media', $data);
	}
}
