<?php  
/**------------------------------------------------------------------------
 * mod_vikicons
 * ------------------------------------------------------------------------
 * author    Valentina Arras - e4j.com
 * copyright Copyright (C) 2021 e4j.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  templates@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted Area'); 

$document = JFactory::getDocument();
$get_bootstrap = $params->get('enable_bootstrap');
$get_fontlibrary = $params->get('enable_fontlib');

JHtml::_('stylesheet', JURI::root().'modules/mod_vikicons/src/mod_vikicons.css');
if($get_fontlibrary == 1) {
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikicons/src/all.css');
}
if($get_bootstrap == 1) {
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikicons/src/bootstrap-theme.min.css');
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikicons/src/bootstrap.min.css');
}


$arrslide = array();

$get_link = $params->get('readmoretext');
$get_textarea_above = $params->get('textarea_above');
$get_size = $params->get('icon_size');
$get_paddingicon = $params->get('padding_icon');
$get_box_dim = $params->get('container_size');
$get_alignment = $params->get('alignment');
$get_style = $params->get('icon_style');
$get_ico_align = $params->get('icon_align');

$slidejstr = $params->get('vikiconsicon', '[]');
$slides = json_decode($slidejstr);
if (count($slides)) {
	foreach ($slides as $sk => $slide) {
		if ((int)$slide->published < 1) {
			continue;
		}
		if (!empty($slide->image)) {
			$imgabpath = JPATH_SITE . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $slide->image);
			/**
			 * Images path may contain information about their size, like:
			 * images/background-04.jpg#joomlaImage://local-images/background-04.jpg?width=1920&height=1080
			 * So we get rid of anything after the hash.
			 * 
			 * @joomla4
			 */
			$img_hash = strpos($imgabpath, '#');
			if ($img_hash !== false) {
				$imgabpath = substr_replace($imgabpath, '', $img_hash);
			}
		}

		/* Link Read More to a different tab */
		if (!empty($slide->linkdest)) {
			$getreadmore_dest = $slide->linkdest;
			if($getreadmore_dest == 1) {
				$readmore_dest = "_blank";
			} else {
				$readmore_dest = "_self";
			}
		}
		
		$slider_entry = '<div class="vikicons-item-inner vikicons-item-'.$get_ico_align.'">';

				$slider_entry .= '<div class="vikicons-item-icon">';
					$slider_entry .= '<span class="vikicons-item-icoelem" style="height:'.$get_size.'px; width:'.$get_size.'px;">';
						if (!empty($slide->linkicon)) {
							$slider_entry .= '<a href="'.$slide->linkicon.'" target="'.$readmore_dest.'">';
						}
							if (!empty($slide->image)) {
								if (is_file($imgabpath)) {
									$slider_entry .= '<img class="vikicons-item-imgico" src="'. $slide->image .'" title="'. $slide->title .'" />';
								}
							} else if (!empty($slide->icontype)) {
								$slider_entry .= '<i style="font-size: '.$get_size.'px;" class="'.$slide->icontype.' fa-'.$slide->icon.'"></i>';
							}

						if (!empty($slide->linkicon)) {
							$slider_entry .= '</a>';
						}
					$slider_entry .= '</span>';
				$slider_entry .= '</div>';

				$slider_entry .= '<div class="vikicons-item-text">';
					if (!empty($slide->title)) {
	    				$slider_entry .= '<h3>'.$slide->title.'</h3>';
					}
					if (!empty($slide->caption)) {
	    				$slider_entry .= '<p>'.$slide->caption.'</p>';
					}
					$slider_entry .= '</div>';
				$slider_entry .= '</div>';
			$arrslide[] = $slider_entry;
	}
}

?>
<div class="vikicons-container">
	<?php if(!empty($get_textarea_above)) { ?>
	<div class="vikicons-topdesc"><?php echo $get_textarea_above; ?></div>
	<?php } ?>
	<div class="vikicons-inner container<?php if($get_box_dim == 1) { echo "-fluid"; } ?>">
		<div class="vikicons-set d-flex flex-wrap <?php if($get_alignment == 0) { echo "vikicons-align-center"; } ?>">
		    <?php
		    if (is_array($arrslide)) {
				foreach($arrslide as $vsl) {
					echo "<div class=\"vikicons-item col-xs-6 col-md-".$get_paddingicon." vikicons-".$get_size." vikicons-".$get_style."\">";
						echo $vsl;
					echo "</div>";
				}
			}
			?>
		</div>
	</div>
</div>
	