<?php  
/**------------------------------------------------------------------------
 * mod_VikContentSlider
 * ------------------------------------------------------------------------
 * author    Valentina Arras - e4j.com
 * Copyright (C) 2014 - 2021 e4j.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  templates@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted Area'); 

$document = JFactory::getDocument();
JHtml::_('stylesheet', JURI::root().'modules/mod_vikcontentslider/css/mod_vikcontentslider.css');
JHtml::_('stylesheet', JURI::root().'modules/mod_vikcontentslider/css/animate.css');
JHtml::_('stylesheet', JURI::root().'modules/mod_vikcontentslider/css/bootstrap.css');

$arrslide = array();

if(intval($params->get('loadjq')) == 1 ) {
	JHtml::_('jquery.framework', true, true);
}
JHtml::_('script', JURI::root().'modules/mod_vikcontentslider/src/popper.js');
JHtml::_('script', JURI::root().'modules/mod_vikcontentslider/src/bootstrap.js');

$get_align = $params->get('textalign');

$timeback = $params->get('timebackground');
$dotsnav = $params->get('dotsnav');
$get_opacity = $params->get('opacity');

$autoplay = $params->get('autoplay');

if($autoplay == 1) {
	$interval = $params->get('interval');
} else {
	$interval = "false";
}
$navigation = $params->get('navigation');
$readmtext = $params->get('readmoretext');
$get_readmore_target = $params->get('readmoretarget');

$navenable = intval($navigation) == 1 ? true : false;
$autoplaygo = intval($autoplay) == 1 ? '1' : '0';

/** New Parameters **/
$first_read = "";
$first_read = true;
$get_title_effect = $params->get('title_effect');
$get_desc_effect = $params->get('desc_effect');
$get_readmore_effect = $params->get('readmore_effect');
$get_fontsize_header = $params->get('fontsize_header');

$slidejstr = $params->get('viksliderimages', '[]');
$slides = json_decode($slidejstr);

if (count($slides)) {
	foreach ($slides as $sk => $slide) {
		if ((int)$slide->published < 1 || empty($slide->image)) {
			continue;
		}
		$imgabpath = JPATH_SITE . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $slide->image);
		
		/**
		 * Images path may contain information about their size, like:
		 * images/background-04.jpg#joomlaImage://local-images/background-04.jpg?width=1920&height=1080
		 * So we get rid of anything after the hash.
		 * 
		 * @joomla4
		 */
		$img_hash = strpos($imgabpath, '#');
		if ($img_hash !== false) {
			$imgabpath = substr_replace($imgabpath, '', $img_hash);
		}

		if (is_file($imgabpath)) {
			$slider_entry = '<div class="slide-item item carousel-item'.($first_read ? ' active' : '').'">';
				$slider_entry .= '<img class="d-block w-100 slide-image vikcs-img-bckground" src="'.JURI::root().$slide->image.'" alt="'.$slide->title.'"/>';
				$slider_entry .= '<div class="bs-slider-overlay" style="opacity: '.$get_opacity.';"></div>';

				$slider_entry .= '<div class="container">'; //Start - Container
					$slider_entry .= '<div class="row">'; //Start - Row
						$slider_entry .= '<div class="slide-text slide_style_'.$get_align.'">'; //Start - slide-text

						if(!empty($slide->title)) {
							$slider_entry .= '<h2 style="font-size: '.$get_fontsize_header.'px;" class="animated '.$get_title_effect.'">'.$slide->title.'</h2>';
						}

						$slider_entry .= '<p class="animated '.$get_desc_effect.'">';
							if(!empty($slide->caption)) {
							$slider_entry .= '<span class="vikcs-desc">'.$slide->caption.'</span>';
							}
						$slider_entry .= '</p>';
						if(!empty($slide->readmore)) {
							$slider_entry .= '<a href="'.$slide->readmore.'" target="'.($get_readmore_target == 1 ? '_blank' : '_self').'" class="btn btn-default" class="animated '.$get_readmore_effect.'">'.$readmtext.'</a>';
						}
			
						$slider_entry .= '<a class="endtext" href="#"></a></div>'; //End - slide-text
					$slider_entry .= '</div>'; //End - Row
				$slider_entry .= '</div>'; //End - Container
			$slider_entry .= '</div>';
		$first_read = false;
		$arrslide[] = $slider_entry;
		}
	}
}

	echo '<div id="vikcstsld-slider" class="carousel slide carousel-fade vikcs-slider" data-ride="carousel" data-interval="'.$interval.'" data-keyboard="true">';

?>

	<!-- Indicators -->
	<?php if($dotsnav == 1) { 
		$first_read = true;
		?>
		<div class="indicators-line">
		    <ol class="carousel-indicators">
		    	<?php
		    		$i = 0;
		    	 foreach($arrslide as $vsl) { ?>
		        	<li data-target="#vikcstsld-slider" data-slide-to="<?php echo $i; ?>" class="<?php echo $first_read ? ' active' : ''; ?>"></li>
		        <?php 
		        $i++;
		        $first_read = false;
		    } ?>
		    </ol>
		</div>
    <?php } ?>

    <!-- Wrapper For Slides -->
    <div class="carousel-inner vikcs-slider" role="listbox">
		<?php 
	    if (is_array($arrslide)) {
			foreach($arrslide as $vsl) {
				echo $vsl;
			}
		}
		?>
	</div><a id="endcontainer" href="#"></a>

    <!-- Left Control -->
	<?php if($navigation == 1) { ?>
	    <a class="carousel-control-prev carousel-control" href="#vikcstsld-slider" role="button" data-slide="prev">
	        <img class="vikcstsld-arrow" src="<?php echo JURI::root()."modules/mod_vikcontentslider/css/src/angle-left-solid.svg"; ?>" aria-hidden="true" />
	        <span class="sr-only">Previous</span>
	    </a>

	    <!-- Right Control -->
	    <a class="carousel-control-next carousel-control" href="#vikcstsld-slider" role="button" data-slide="next">
	        <img class="vikcstsld-arrow" src="<?php echo JURI::root()."modules/mod_vikcontentslider/css/src/angle-right-solid.svg"; ?>" aria-hidden="true" />
	        <span class="sr-only">Next</span>
	    </a>
	<?php } ?>
</div>

<script type="text/javascript">
jQuery.noConflict();
	jQuery(document).ready(function() {
		var text_end = 0;
		if (jQuery('.slide-item.active').find('.endtext').length) {
			text_end = jQuery('.slide-item.active').find('.endtext').offset().top;
		}
		var general_end = jQuery('#endcontainer').offset().top;
		var distance = general_end - text_end;
		var text_box = jQuery('.slide-text');
		var slider_box = jQuery('.slide-item'); 
		if(distance <= 100) {
			if(distance <= 20) {
				slider_box.addClass('slide-text-pos-hid-btn');
				text_box.addClass('slide-text-position-10');
			} else {
				text_box.addClass('slide-text-position-10');
			}
							
		}
		
		jQuery(window).resize(function() {
			var text_end = 0;
			if (jQuery('.slide-item.active').find('.endtext').length) {
				text_end = jQuery('.slide-item.active').find('.endtext').offset().top;
			}
			var general_end = jQuery('#endcontainer').offset().top;
			var distance = general_end - text_end;
			var text_box = jQuery('.slide-text');
			var slider_box = jQuery('.slide-item');
			setTimeout(function() {
				if(distance <= 100) {
					if(distance <= 20) {
						slider_box.addClass('slide-text-pos-hid-btn');
						text_box.addClass('slide-text-position-10');
					} else {
						text_box.addClass('slide-text-position-10');
					}				
				} else if(distance > 100) {
					text_box.removeClass('slide-text-position-10');
					slider_box.removeClass('slide-text-pos-hid-btn');
				}
			}, 2000);			
			
		});
	});
    jQuery('.carousel').carousel();

	jQuery('img[src$=".svg"]').each(function() {
        var $img = jQuery(this);
        var imgURL = $img.attr('src');
        var attributes = $img.prop("attributes");

        jQuery.get(imgURL, function(data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');

            // Remove any invalid XML tags
            $svg = $svg.removeAttr('xmlns:a');

            // Loop through IMG attributes and apply on SVG
            jQuery.each(attributes, function() {
                $svg.attr(this.name, this.value);
            });

            // Replace IMG with SVG
            $img.replaceWith($svg);
        }, 'xml');
    });
</script>
